/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.connected;

import java.nio.file.Path;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonarsource.sonarlint.core.client.api.common.analysis.ClientInputFile;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;

@Immutable
public class ConnectedAnalysisConfiguration
extends StandaloneAnalysisConfiguration {
    private final String moduleKey;

    public ConnectedAnalysisConfiguration(@Nullable String moduleKey, Path baseDir, Path workDir, Iterable<ClientInputFile> inputFiles, Map<String, String> extraProperties) {
        super(baseDir, workDir, inputFiles, extraProperties);
        this.moduleKey = moduleKey;
    }

    @CheckForNull
    public String moduleKey() {
        return this.moduleKey;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n");
        if (this.moduleKey != null) {
            sb.append("  moduleKey: ").append(this.moduleKey).append("\n");
        }
        sb.append("  baseDir: ").append(this.baseDir()).append("\n");
        sb.append("  workDir: ").append(this.workDir()).append("\n");
        sb.append("  extraProperties: ").append(this.extraProperties()).append("\n");
        sb.append("  inputFiles: [\n");
        for (ClientInputFile inputFile : this.inputFiles()) {
            sb.append("    ").append(inputFile.getPath().toString());
            if (inputFile.isTest()) {
                sb.append(" [test]");
            }
            sb.append("\n");
        }
        sb.append("  ]\n");
        sb.append("]\n");
        return sb.toString();
    }
}

